@extends('layouts.app')

@section('title', 'Order Details')

@section('content')
<div class="container mx-auto">
    <h1 class="text-2xl font-bold mb-4">Order Details</h1>

    <div class="card mb-4">
        <div class="card-body">
            <h5 class="card-title">Order #{{ $orderItems->first()->order->id }}</h5>
            <p><strong>Date:</strong> {{ $orderItems->first()->order->created_at->format('M d, Y') }}</p>
            <p><strong>Status:</strong> {{ ucfirst($orderItems->first()->order->status) }}</p>
        </div>
    </div>

    <h3>Order Items</h3>
    <table class="table">
        <thead>
            <tr>
                <th>Product</th>
                <th>Quantity</th>
                <th>Price</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($orderItems as $item)
                <tr>
                    <td>{{ $item->inventoryItem->product->name }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td>${{ number_format($item->price, 2) }}</td>
                    <td>${{ number_format($item->price * $item->quantity, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <a href="{{ route('seller.orders.index') }}" class="btn btn-secondary">Back to Orders</a>
</div>
@endsection